/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import org.drools.io.Resource;
import org.drools.io.impl.BaseResource;
import org.drools.io.internal.InternalResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputStreamResource
extends BaseResource
implements InternalResource {
    private transient InputStream stream;
    private String encoding;

    public InputStreamResource(InputStream stream) {
        this(stream, null);
    }

    public InputStreamResource(InputStream stream, String encoding) {
        if (stream == null) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        this.stream = stream;
        this.encoding = encoding;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.stream;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.encoding == null) {
            return new InputStreamReader(this.getInputStream());
        }
        return new InputStreamReader(this.getInputStream(), this.encoding);
    }

    @Override
    public URL getURL() throws IOException {
        throw new FileNotFoundException("InputStream cannot be resolved to URL");
    }

    @Override
    public boolean hasURL() {
        return false;
    }

    @Override
    public long getLastModified() {
        throw new IllegalStateException("InputStream does have a modified date");
    }

    @Override
    public long getLastRead() {
        throw new IllegalStateException("InputStream does have a modified date");
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public Collection<Resource> listResources() {
        throw new RuntimeException("This Resource cannot be listed, or is not a directory");
    }
}

